/*
SQLyog Community v11.01 (64 bit)
MySQL - 5.5.41-log : Database - 25_02_trunk
*********************************************************************
*/

SET FOREIGN_KEY_CHECKS= 0;

TRUNCATE `dydt_data_line_item`; 
TRUNCATE  `dydt_data_provider`; 
TRUNCATE `dydt_data_provider_param`; 
TRUNCATE `dydt_document_data_provider`; 
TRUNCATE `dydt_document_param`; 
TRUNCATE `dydt_document_type`; 
TRUNCATE `dydt_owner_conf`; 
TRUNCATE `dydt_template_conf`;
TRUNCATE dydt_templateparams_translations;


insert  into `dydt_data_line_item`(`id`,`dataProviderId`,`dataSourceCode`,`executionOrder`,`publishAsParametersDef`,`whetherDataSource`,`whetherPrimaryDataSource`,`sqlSelectQueryDef`,`whereClauseBindingDef`,`resultColumnsDef`,`formattersDef`,`sqlWhereQueryDef`,`whetherMultiRecord`) values (1,3,'OFFER_LETTER_ADDITIONAL_PARAM',1,'application_id=PRM_APPLICATION_ID,program_id=PRM_PROGRAM_ID,academy_location_id=PRM_ACADEMY_LOCATION_ID,applicant_person_id=PRM_APPLICANT_PERSON_ID,program_batch_seat_configid=PRM_PROGRAM_BATCH_SEAT_CONFIG_ID',0,0,'SELECT applicationId AS application_id ,programId AS program_id ,academyLocationId AS academy_location_id,a.applicantPersonId as applicant_person_id ,\r\nprogBatchSeatConfigId as program_batch_seat_configid\r\nFROM application_program ap\r\ninner join application a on ap.applicationId = a.id\r\n','PRM_APPLICATION_PROGRAM_ID','application_id,program_id,academy_location_id,applicant_person_id,program_batch_seat_configid',NULL,'WHERE ap.id=PRM_APPLICATION_PROGRAM_ID',0),(2,3,'APPLICATION_INFO',2,NULL,1,1,'SELECT  p.programCode AS program_code,p.programName AS program_name,p.programNameToBePrint AS program_print_name,\r\npd.shortCode AS primary_dept_code,pd.deptName AS primary_dept_name,\r\npsd.shortCode AS secondary_dept_code,psd.deptName AS secondary_dept_name,\r\nb.batchName AS batch_name ,b.startDate AS batch_start_date ,b.tillDate AS batch_tilldate,\r\nay.yearName AS academic_year\r\nFROM application_program aprgm\r\nINNER JOIN programs p ON aprgm.programId = p.id\r\nINNER JOIN prog_batch_seat_config pbsc ON aprgm.progBatchSeatConfigId = pbsc.id\r\nINNER JOIN batches b   ON b.id = pbsc.programBatchId\r\nINNER JOIN academy_year ay ON ay.id = b.academicYear\r\nINNER JOIN department pd ON pd.id = p.programDepartmentId\r\nLEFT JOIN department psd ON psd.id = p.subDepartmentId','PRM_APPLICATION_PROGRAM_ID','program_code,program_name,program_print_name, primary_dept_code,primary_dept_name,secondary_dept_code,secondary_dept_name, batch_name, batch_start_date,batch_end_date,batch_tilldate,academic_year',NULL,'WHERE aprgm.id=PRM_APPLICATION_PROGRAM_ID',0),(3,3,'APPLICATION_INFO',3,NULL,1,1,'SELECT ap.firstName AS applicant_firstname ,ap.lastName AS applicant_lastname ,ap.middleName AS applicant_middlename, \r\nap.gender AS applicant_gender,ap.printName  AS applicant_printname,a.code as application_code,\r\ns.salutationName as applicant_salutation,ap.birthDate as birth_date\r\nFROM application a\r\nINNER JOIN  applicant_person ap ON a.applicantPersonId = ap.id\r\nINNER JOIN salutations s ON ap.salutationId = s.id\r\n ','PRM_APPLICATION_ID','applicant_firstname,applicant_lastname,applicant_middlename,applicant_gender,applicant_printname,application_code,applicant_salutation,birth_date',NULL,'WHERE a.id=PRM_APPLICATION_ID',0),(4,2,'ACADEMYLOCATION_ADDRESS',1,NULL,1,0,'SELECT \r\nal.academyId AS academy_id , al.locationId AS location_id , al.academyName AS academy_name , al.locationName AS location_name,\r\nc.countryName AS country_name , cr.countryRegionName AS region_name ,\r\npr.countryRegionName AS parent_region_name,ct.cityName AS city_name , addressText AS address_detail,\r\nad.phoneCountryCode AS phone_country_code,ad.phoneAreaCode AS phone_area_code,\r\nad.phoneNo AS phone_no ,ad.cellCountryCode AS cell_country_code,ad.cellNo AS cell_no,\r\nad.primaryeEmailId as primary_email_id, al.path as img_academy_location\r\nFROM academy_location al\r\nINNER JOIN location_addresses la ON al.locationId = la.locationId\r\nINNER JOIN address ad ON la.addressId = ad.id AND ad.addressTypeId = 3\r\nLEFT JOIN city ct ON ct.id =ad.cityId\r\nLEFT JOIN country c ON ad.countryId = c.id\r\nLEFT JOIN country_region cr ON ad.countryRegionId = cr.id\r\nLEFT JOIN country_region pr ON ad.parentRegionId = pr.id','PRM_ACADEMY_LOCATION_ID','academy_id,location_id,academy_name,location_name,country_name,region_name,parent_region_name,city_name,address_detail,phone_country_code,phone_area_code,phone_no,cell_country_code,cell_no,primary_email_id,img_academy_location',NULL,'WHERE al.id = PRM_ACADEMY_LOCATION_ID',0),(5,4,'APPLICATION_PROGRAM_INFO',1,NULL,1,1,'SELECT \r\nal.academyName as academy_name,al.locationName as location_name,\r\np.programCode as program_code ,p.programName as program_name,p.programNameToBePrint as program_print_name ,\r\nb.batchName as batch_name,b.startDate as batch_start_date,b.tillDate as batch_till_date,\r\nst.seatCode as seat_code,st.seatName as seat_name \r\nfrom application_program ap\r\nINNER JOIN academy_location al ON ap.academyLocationId = al.id\r\nINNER JOIN programs p ON p.id = ap.programId\r\nINNER JOIN prog_batch_seat_config pbsc ON pbsc.id  = ap.progBatchSeatConfigId \r\nINNER JOIN batches b ON b.id = pbsc.programBatchId \r\nINNER JOIN seat_types st ON pbsc.seatTypeId=st.id','PRM_APPLICATION_ID','academy_name,location_name,program_code,program_name,program_print_name,batch_name,batch_start_date,batch_till_date,seat_code,seat_name',NULL,'WHERE ap.applicationId = PRM_APPLICATION_ID',0),(6,4,'APPLICANT_INFO',2,NULL,1,0,'SELECT ap.firstName AS app_first_name,ap.middleName AS app_middle_name , ap.lastName AS app_last_name,\r\n       ap.mobileNumber AS app_mobile_number , ap.emailId AS app_email_id, ap.gender AS app_gender,\r\n       ap.birthDate AS app_birthdate, ap.bloodGroup AS app_bloodgroup, ap.photoURL AS img_app_photo_url,\r\n       ap.maritalStatus AS app_marital_status, ap.printName AS app_print_name,\r\n       ap.personalIncome AS app_personal_income, ap.occupation AS app_occupation,\r\n       ap.category AS app_category,a.code AS applctn_code,\r\n       cs.itemValue AS app_caste_category,rg.itemValue AS app_religion,nt.itemValue AS app_nationality,\r\n       cn.countryName AS app_country_name,sn.salutationName AS app_salutation\r\nFROM applicant_person ap \r\nINNER JOIN application a ON a.applicantPersonId = ap.id\r\nLEFT JOIN caste_categories cs ON cs.id = ap.casteCategoryId\r\nLEFT JOIN religions rg ON rg.id = ap.religionId\r\nLEFT JOIN nationalities nt ON nt.id = ap.nationalityId\r\nLEFT JOIN country cn ON cn.id = ap.countryId        \r\nLEFT JOIN salutations sn ON sn.id = ap.salutationId','PRM_APPLICATION_ID','app_first_name,app_middle_name,app_last_name,app_mobile_number,app_email_id,app_gender,app_birthdate,app_bloodgroup,app_photo_url,app_marital_status,app_print_name,app_personal_income,app_occupation,app_category,applctn_code,app_caste_category,app_religion,app_nationality,app_country_name,app_salutation',NULL,'WHERE a.id=PRM_APPLICATION_ID',0),(7,1,'ORGANIZATION_ADDRESS',1,NULL,1,0,'SELECT o.orgName as organization_name,c.countryName AS country_name , cr.countryRegionName AS region_name ,\r\npr.countryRegionName AS parent_region_name,ct.cityName AS city_name , addressText AS address_detail,\r\nad.phoneCountryCode AS phone_country_code,ad.phoneAreaCode AS phone_area_code,\r\nad.phoneNo AS phone_no ,ad.cellCountryCode AS cell_country_code,ad.cellNo AS cell_no,\r\nad.primaryeEmailId AS primary_email_id\r\nFROM organizations o\r\nINNER JOIN organization_addresses oa ON o.id = oa.organizationId\r\nINNER JOIN address ad ON oa.addressId = ad.id AND ad.addressTypeId AND ad.addressTypeId=1\r\nLEFT JOIN city ct ON ct.id =ad.cityId\r\nLEFT JOIN country c ON ad.countryId = c.id\r\nLEFT JOIN country_region cr ON ad.countryRegionId = cr.id\r\nLEFT JOIN country_region pr ON ad.parentRegionId = pr.id',NULL,'organization_name,country_name,region_name,parent_region_name,city_name,address_detail,phone_country_code,phone_area_code,phone_no,cell_country_code,cell_no,primary_email_id',NULL,NULL,0),(8,3,'ADMISSION_PENDING_DOCUMENTS',4,NULL,1,0,'SELECT    dt.itemCode AS document_code ,dt.itemValue AS document_name ,ard.status AS document_submission_status \r\nFROM application_program ap\r\nINNER JOIN program_selection_process psp ON psp.programBatchSeatConfigId = ap.progBatchSeatConfigId\r\nINNER JOIN application_required_documents ard ON psp.id = ard.programSelectionProcessId\r\nINNER JOIN document_types dt ON ard.documentTypeId = dt.id','PRM_APPLICATION_PROGRAM_ID,PRM_APPLICATION_ID','document_code,document_name,document_submission_status',NULL,'WHERE ap.id=PRM_APPLICATION_PROGRAM_ID AND ard.applicableAt=\"ADMISSION\" AND ap.applicationId=PRM_APPLICATION_ID\r\nAND ard.applicationId=PRM_APPLICATION_ID',1),(9,3,'APPLICANT_ADDRESS_INFO',5,NULL,1,0,'SELECT  c.countryName AS country_name , cr.countryRegionName AS region_name ,\r\npr.countryRegionName AS parent_region_name,ct.cityName AS city_name , addressText AS address_detail,\r\nad.phoneCountryCode AS phone_country_code,ad.phoneAreaCode AS phone_area_code,\r\nad.phoneNo AS phone_no ,ad.cellCountryCode AS cell_country_code,ad.cellNo AS cell_no ,\r\nad.primaryEmailId AS primary_email_id\r\nFROM applicant_address ad\r\nLEFT JOIN city ct ON ct.id =ad.cityId\r\nLEFT JOIN country c ON ad.countryId = c.id\r\nLEFT JOIN country_region cr ON ad.countryRegionId = cr.id\r\nLEFT JOIN country_region pr ON ad.parentRegionId = pr.id','PRM_APPLICANT_PERSON_ID','country_name,region_name,parent_region_name,city_name,address_detail,\r\nphone_country_code,phone_area_code,phone_no,cell_country_code,cell_no,primary_email_id',NULL,'WHERE ad.applicantPersonId=PRM_APPLICANT_PERSON_ID and whetherPrimary=1',0),(10,3,'APPLICATION_PROGRAM_FEE_PLAN',6,NULL,1,0,'select \r\n    fee_plan.feePlanName as fee_plan_name,fee_heads.feeHeadName as fee_head_name ,sum(fee_stage_head_config.feeAmount) as amount\r\nfrom\r\n    fee_stage_head_config\r\n        left join\r\n    fee_plan_rule_stage ON fee_stage_head_config.feePlanRuleStageId = fee_plan_rule_stage.id\r\n        left join\r\n    fee_plan_rules ON fee_plan_rule_stage.feePlanRuleId = fee_plan_rules.id\r\n        left join\r\n    fee_plan ON fee_plan_rules.feePlanId = fee_plan.id\r\n        left join\r\n    fee_plan_acad_locations ON fee_plan.id = fee_plan_acad_locations.id\r\n        left join\r\n    fee_stage_master ON fee_plan_rule_stage.stageId = fee_stage_master.id\r\n        left join\r\n    fee_heads ON fee_stage_head_config.feeHeadId = fee_heads.id\r\n\r\n\r\n','PRM_PROGRAM_BATCH_SEAT_CONFIG_ID','fee_plan_name,fee_head_name,amount',NULL,'WHERE  fee_stage_master.stageName=\'Admission\' AND fee_plan_rules.feeSpecificLinkType=\'NOT_APPLICABLE\'\r\n AND fee_plan.feePlanStatus=\'ACTIVE\' AND  fee_plan_acad_locations.progBatchSeatConfigId=PRM_PROGRAM_BATCH_SEAT_CONFIG_ID\r\nGROUP BY fee_stage_head_config.feePlanRuleStageId',0),(11,3,'ACAD_LCTN_SALES_OWNER',7,NULL,1,0,'SELECT p.printName AS sales_head_printname,p.mobileNumber as sales_head_mobile\r\nFROM academy_location_purpose alp\r\nINNER JOIN staffs s ON s.userId = alp.ownerId\r\nINNER JOIN persons p ON p.id = s.personId','PRM_ACADEMY_LOCATION_ID','sales_head_printname,sales_head_mobile',NULL,'WHERE alp.academyLocationId = PRM_ACADEMY_LOCATION_ID AND alp.purposeCode=\'SALES_OFFICE\'',0),(12,3,'ACADEMY_LOCATION_BANKS',8,NULL,1,0,'SELECT b.bankCode AS bank_code,b.ifscCode AS ifsc_code,b.accountNo AS bank_account_no, b.bankName AS bank_name,\r\nb.branchName AS branch_name,b.branchAddress AS bank_branch_address\r\nFROM bank b\r\nINNER JOIN academies a ON b.academyId = a.id\r\nINNER JOIN locations l ON b.locationId = l.id\r\nINNER JOIN academy_location al ON al.academyId = a.id AND al.locationId = l.id','PRM_ACADEMY_LOCATION_ID','bank_code,ifsc_code,bank_account_no,bank_name,branch_name,bank_branch_address',NULL,'WHERE al.id = PRM_ACADEMY_LOCATION_ID',1);

/*Data for the table `dydt_data_provider` */

insert  into `dydt_data_provider`(`id`,`providerName`,`priority`) values (1,'ORGANIZATION_INFO',5),(2,'ACADEMY_LOCATION_INFO',5),(3,'OFFER_LETTER_INFO',1),(4,'AFRM_INF',1);

/*Data for the table `dydt_data_provider_param` */

insert  into `dydt_data_provider_param`(`id`,`parameterId`,`typeCode`,`providerId`) values (2,1,'IN',3),(3,4,'OUT',3),(4,2,'OUT',3),(5,3,'OUT',3),(6,2,'IN',4),(7,5,'OUT',3),(8,6,'OUT',3),(9,3,'IN',2);

/*Data for the table `dydt_document_data_provider` */

insert  into `dydt_document_data_provider`(`id`,`dataProviderId`,`documentTypeId`) values (1,1,1),(2,3,1),(3,1,2),(4,4,2),(5,2,1);

/*Data for the table `dydt_document_param` */

insert  into `dydt_document_param`(`id`,`paramCode`) values (1,'PRM_APPLICATION_PROGRAM_ID'),(2,'PRM_APPLICATION_ID'),(3,'PRM_ACADEMY_LOCATION_ID'),(4,'PRM_PROGRAM_ID'),(5,'PRM_APPLICANT_PERSON_ID'),(6,'PRM_PROGRAM_BATCH_SEAT_CONFIG_ID');

/*Data for the table `dydt_document_type` */

insert  into `dydt_document_type`(`id`,`typeName`,`configLevelCode`,`whetherEditable`,`whetherDeletable`,`typeCode`,`availableForAdhoc`) values (1,'OFFER_LETTER','PROGRAM_BATCH_SEAT_TYPE_LEVEL',0,0,'OFFER_LETTER',0),(2,'APPLICATION_FORM','ACADEMY_LOCATION_LEVEL',0,0,'APPLICATION_FORM',0);

/*Data for the table `dydt_jasper_resources` */

/*Data for the table `dydt_owner_conf` */

/*Data for the table `dydt_template_conf` */

/*Data for the table `dydt_templateparams_translations` */

insert  into `dydt_templateparams_translations`(`id`,`translationCode`,`translationValue`,`dataProviderLineItemId`) values (1,'program_code','Program Code',2),(2,'program_name','Program Name',2),(3,'program_print_name','Program Print Name',2),(4,'primary_dept_code','Primary Department Code',2),(5,'primary_dept_name','Primary Department Name',2),(6,'secondary_dept_code','Secondary Department Code',2),(7,'secondary_dept_name','Secondary Department Name',2),(8,'batch_name','Batch Name',2),(9,'batch_start_date','Batch Start Date',2),(10,'batch_end_date','Batch End Date',2),(11,'batch_tilldate','Batch Till Date',2),(12,'academic_year','Academic Year',2),(13,'applicant_firstname','Applicant First Name',3),(14,'applicant_lastname','Applicant Last Name',3),(15,'applicant_middlename','Applicant Middle Name',3),(16,'applicant_gender','Applicant Gender',3),(17,'applicant_printname','Applicant Print Name',3),(18,'application_code','Applicant Code',3),(19,'applicant_salutation','Applicant Salutation',3),(20,'birth_date','Applicant Birth Date',3),(21,'academy_id','Academy Id',4),(22,'location_id','Location Id',4),(23,'academy_name','Academy Name',4),(24,'location_name','Location Name',4),(25,'country_name','Academy Location Country Name',4),(26,'region_name','Academy Location Region Name',4),(27,'parent_region_name','Academy Location Parent Region Name',4),(28,'city_name','Academy Location City Name',4),(29,'phone_country_code','Academy Location Phone Country Code',4),(30,'phone_area_code','Academy Location Phone Area Code',4),(31,'phone_no','Academy Location Phone No',4),(32,'cell_country_code','Academy Location Cell Country Code',4),(33,'cell_no','Academy Location Cell No',4),(34,'primary_email_id','Academy Location Primary EmailId',4),(35,'img_academy_location','Academy Location Logo',4),(36,'document_code','Pending Document Code',8),(37,'document_name','Pending Document Name',8),(38,'document_submission_status','Pending Document Status',8),(39,'country_name','Applicant Country Name',9),(40,'region_name','Applicant Region Name',9),(41,'parent_region_name','Applicant Parent Region Name',9),(42,'city_name','Applicant City Name',9),(43,'address_detail','Applicant Address Detail',9),(44,'phone_country_code','Applicant Phone Country Code',9),(45,'phone_area_code','Applicant Phone Area Code',9),(46,'phone_no','Applicant Phone No',9),(47,'cell_country_code','Applicant Cell Country Code',9),(48,'cell_no','Applicant Cell No',9),(49,'primary_email_id','Applicant Primary Email',9),(50,'fee_plan_name','Fee Plan Name',10),(51,'fee_head_name','Fee Head Name',10),(52,'amount','Fee Amount',10),(53,'sales_head_printname','Academy Location Sales Head PrintName',11),(54,'sales_head_mobile','Academy Location Sales Head Mobile',11),(55,'bank_code','Bank Code',12),(56,'ifsc_code','IFSC Code',12),(57,'bank_account_no','Account No',12),(58,'bank_name','Bank Name',12),(59,'branch_name','Branch Name',12),(60,'bank_branch_address','Branch Address',12),(61,'organization_name','Organization Name',7),(62,'country_name','Organization Country Name',7),(63,'region_name','Organization Region Name',7),(64,'parent_region_name','Organization Parent Region Name',7),(65,'city_name','Organization City Name',7),(66,'address_detail','Organization Address Detail',7),(67,'phone_country_code','Organization Phone Country Code',7),(68,'phone_area_code','Organization Phone Area Code',7),(69,'phone_no','Organization Phone No',7),(70,'cell_country_code','Organization Cell Country Code',7),(71,'cell_no','Organization Cell No',7),(72,'primary_email_id','Organization Primary EmailId',7),(73,'academy_name','Academy Name',5),(74,'location_name','Location Name',5),(75,'program_code','Program Code',5),(76,'program_name','Program Name',5),(77,'program_print_name','Program Print Name',5),(78,'batch_name','Batch Name',5),(79,'batch_start_date','Batch Start Date',5),(80,'batch_till_date','Batch Till Date',5),(81,'seat_code','Seat Code',5),(82,'app_first_name','Applicant First Name',6),(83,'app_middle_name','Applicant Middle Name',6),(84,'app_last_name','Applicant Last Name',6),(85,'app_mobile_number','Applicant Mobile No',6),(86,'app_email_id','Applicant Email Id',6),(87,'app_gender','Applicant Gender',6),(88,'app_birthdate','Applicant Birth Date',6),(89,'app_bloodgroup','Applicant Blood Group',6),(90,'img_app_photo_url','Applicant Profile Photo',6),(91,'app_marital_status','Applicant Marital Status',6),(92,'app_print_name','Applicant Print Name',6),(93,'app_personal_income','Applicant Personal Income',6),(94,'app_occupation','Applicant Occupation',6),(95,'app_category','Applicant Category',6),(96,'applctn_code','Application Code',6),(97,'app_caste_category','Applicant Caste Category',6),(98,'app_religion','Applicant Religion',6),(99,'app_salutation','Applicant Salutation',6),(100,'organization_name','Organization Name',7),(101,'country_name','Organization Country Name',7),(102,'region_name','Organization Region Name',7),(103,'parent_region_name','Organization Parent Region Name',7),(104,'city_name','Organization City Name',7),(105,'address_detail','Organization Address Detail',7),(106,'phone_country_code','Organization Phone Country Code',7),(107,'phone_area_code','Organization Phone Area Code',7),(108,'phone_no','Organization Phone No',7),(109,'cell_country_code','Organization Cell Country Code',7),(110,'cell_no','Organization Cell No',7),(111,'primary_email_id','Organization Primary Email',7),(112,'seat_name','Seat Name',5),(113,'ADMISSION_PENDING_DOCUMENTS_TABLE_REP','Admission Pending Document (Tabular)',8),(114,'ADMISSION_PENDING_DOCUMENTS_BULLETED_REP','Admission Pending Document (Bulleted)',8),(115,'ACADEMY_LOCATION_BANKS_TABLE_REP','Academy Location Banks(Tabular)',12),(116,'ACADEMY_LOCATION_BANKS_BULLETED_REP','Academy Location Banks(Bulleted)',12);


-- insert scripts for offer letter. 
-- Script to get applicant father name
INSERT INTO `dydt_data_line_item` (`dataProviderId`, `dataSourceCode`, `executionOrder`, `whetherDataSource`, `whetherPrimaryDataSource`, `sqlSelectQueryDef`, `whereClauseBindingDef`, `resultColumnsDef`, `sqlWhereQueryDef`, `whetherMultiRecord`) VALUES ('3', 'APPLICANT_FATHER_NAME', '11', '1', '0', 'select apf.printName as father_name from applicant_person_relationships as apr\ninner join applicant_person as ap on apr.applicantPersonId = ap.id\ninner join applicant_person as apf on apr.relatedApplicantPersonId = apf.id', 'PRM_APPLICANT_PERSON_ID', 'father_name', 'WHERE ap.id = PRM_APPLICANT_PERSON_ID and apr.relationship=\'FATHER\'', '0');

SET @fatheNameId=(SELECT MAX(id) FROM dydt_data_line_item);

INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`, 
`dataProviderLineItemId`) VALUES ('father_name', 'Father Name', @fatheNameId); 

-- Script to get offer letter expiry date
INSERT INTO `dydt_data_line_item` (`dataProviderId`, `dataSourceCode`, `executionOrder`, `whetherDataSource`, `whetherPrimaryDataSource`, 
`sqlSelectQueryDef`, `whereClauseBindingDef`, `resultColumnsDef`, `sqlWhereQueryDef`, `whetherMultiRecord`) VALUES ('3', 'OFFER_LETTER_EXPIRY_DATE', '12', '1', '0', 'select DATE_FORMAT(DATE_ADD(curdate(), interval pp.offerLetterAcceptDaysLimit day) ,\'%d-%m-%Y\') as offer_exp_date\nfrom prog_slctn_process_admisn_conf as pp\nleft join program_selection_process as psp on pp.programSelectionProcessId=psp.id\nleft join application_program as ap on ap.progBatchSeatConfigId = psp.programBatchSeatConfigId ', 'PRM_APPLICATION_PROGRAM_ID', 'offer_exp_date', 'WHERE ap.id=PRM_APPLICATION_PROGRAM_ID', '0');

SET @offerLetterExpDate=(SELECT MAX(id) FROM dydt_data_line_item);

INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`, `dataProviderLineItemId`) 
VALUES ('offer_exp_date', 'Offer Letter Expiry Date', @offerLetterExpDate);  

-- script to get batch start date, end date, batch duration

INSERT INTO `dydt_data_line_item` (`dataProviderId`, `dataSourceCode`, `executionOrder`, `whetherDataSource`, `whetherPrimaryDataSource`, `sqlSelectQueryDef`, `whereClauseBindingDef`, `resultColumnsDef`, `sqlWhereQueryDef`, `whetherMultiRecord`) VALUES ('3', 'BATCH_DETAILS', '13', '1', '0', 'select round(datediff(b.tillDate,b.startDate) / 365) as batch_year, \nDATE_FORMAT(b.startDate ,\'%d-%m-%Y\') as batch_start_date,\nif(b.batchPartTime=1, \'Part Time\', \'Full Time\') as batch_study_mode \nfrom application_program as ap\ninner join prog_batch_seat_config as pbsc on ap.progBatchSeatConfigId = pbsc.id\ninner join batches as b on pbsc.programBatchId = b.id', 'PRM_APPLICATION_PROGRAM_ID', 'batch_year, batch_start_date, batch_study_mode', 'WHERE ap.id=PRM_APPLICATION_PROGRAM_ID', '0'); -- save it and get ID : 17

SET @batchInformationNYear=(SELECT MAX(id) FROM dydt_data_line_item);

INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`, `dataProviderLineItemId`) VALUES ('batch_year', 'Batch Duration in Year', @batchInformationNYear);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`, `dataProviderLineItemId`) VALUES ('batch_start_date', 'Batch Start Date', @batchInformationNYear);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`, `dataProviderLineItemId`) VALUES ('batch_study_mode', 'Batch Study Mode', @batchInformationNYear);

-- Added UoA, Jaipuria and JLU offer letter
INSERT INTO `dydt_template_conf` VALUES (1,1,'JAIPURIA_OFFER_LETTER','HTMLTEMPLATE',0,NULL,NULL,NULL,NULL,'\n<!DOCTYPE html>\n<html>\n<head>\n	<title></title>\n	<style type=\"text/css\">body{\n    font-family:calibri;\n    font-size:15px;\n}\n	</style>\n	<style type=\"text/css\">@page { \n      margin: 4cm, 1cm, 2.5cm, 1cm; \n      @top-center { \n        content: element(pageHeader); \n      } \n\n       @bottom-center { \n        content: element(pageFooter);\n        width: 100%\n       }\n} \n\n#pageHeader{ \n   position: running(pageHeader); \n} \n#pageFooter{ \n   position: running(pageFooter); \n}\n	</style>\n</head>\n<body>\n \n\n<table align=\"center\" border=\"0\" width=\"90%\" id=\"pageHeader\">\n	<tbody>\n		<tr>\n			<td align=\"right\" colspan=\"2\"> <img alt=\"\" src=\"file://$DATA.img_academy_location\" style=\"height:80px; width:300px\" /> </td>\n		</tr>\n	</tbody>\n</table>\n\n\n<p id=\"pageFooter\">&nbsp;</p>\n\n<table align=\"center\" border=\"0\" width=\"90%\">\n	<tbody>\n		<tr>\n			<td style=\"width:50%\">\n			<p>&nbsp;</p>\n			</td>\n			<td style=\"text-align:right\"><span><strong>Reference No.................................</strong><br />\n			<strong>Registraton No:&nbsp;$DATA.application_code</strong><br />\n			\n			<strong>Date:&nbsp; $date.get(&quot;d MMMM,y&quot;) </strong></span></td>\n		</tr>\n	</tbody>\n</table>\n\n<table align=\"center\" border=\"0\" width=\"90%\">\n	<tbody>\n		<tr>\n			<td colspan=\"2\">\n			<p style=\"text-align:left; text-decoration:none\"><span style=\"font-size:16px\"><strong>Miss / Master&nbsp;$DATA.applicant_printname</strong><br />\n			<br />\n			<strong>Daughter / Son of&nbsp;$DATA.father_name</strong></span></p>\n			</td>\n		</tr>\n	</tbody>\n</table>\n\n<table align=\"center\" border=\"0\" width=\"90%\">\n	<tbody>\n		<tr>\n			<td colspan=\"2\">\n			<p style=\"text-align:left;\"><strong>Sub: Admission for Academic Session 2015 &ndash; 2016 in Class&nbsp;$DATA.program_print_name</strong><br />\n			<br />\n			<strong>Dear&nbsp;$DATA.applicant_printname</strong><br />\n			<br />\n			Greetings from Seth M.R. Jaipuria School, Barabanki!</p>\n\n			<p style=\"text-align: justify;\">Congratulation! We are happy to offer you admission to our prestigious school for your ward\'s education in Class $DATA.program_print_name&nbsp;Make sure your uniform, books, shoes and everything else is ready before time!</p>\n\n			<p style=\"text-align: justify;\">When we unleash the power of our thoughts, nothing remains impossible. At your school, we will give you tools to learn and think, and then let you truly become what you want be!</p>\n\n			<p style=\"text-align: justify;\">Looking forward to seeing you very soon!</p>\n\n			<p align=\"left\">Warm Regards,<br />\n			&nbsp;</p>\n			</td>\n		</tr>\n	</tbody>\n</table>\n\n<table align=\"center\" border=\"0\" width=\"90%\">\n	<tbody>\n		<tr>\n			<td colspan=\"2\"><strong>............................</strong><br />\n			<strong>Principal</strong><br />\n			<strong>Seth M.R. Jaipuria School, Barabanki</strong></td>\n		</tr>\n	</tbody>\n</table>\n\n<div style=\"page-break-after: always\"><span style=\"display: none;\">&nbsp;</span></div>\n\n<table align=\"center\" border=\"0\" width=\"90%\">\n	<tbody>\n		<tr>\n			<td style=\"width:50%\">\n			<p>&nbsp;</p>\n			</td>\n			<td style=\"text-align:right\"><span><strong>Reference No.................................</strong><br />\n			<strong>Registraton No: &nbsp;$DATA.application_code</strong><br />\n			</span>\n			<span><strong>Date: $date.get(&quot;d MMMM,y&quot;)</strong> </span></td>\n		</tr>\n	</tbody>\n</table>\n\n<table align=\"center\" border=\"0\" width=\"90%\">\n	<tbody>\n		<tr>\n			<td colspan=\"2\">\n			<p style=\"text-align:left; text-decoration:none\"><span style=\"font-size:16px\"><strong>Miss / Master&nbsp;$DATA.applicant_printname</strong><br />\n			<br />\n			<strong>Daughter / Son of&nbsp;$DATA.father_name</strong></span></p>\n			</td>\n		</tr>\n	</tbody>\n</table>\n\n<table align=\"center\" border=\"0\" width=\"90%\">\n	<tbody>\n		<tr>\n			<td colspan=\"2\">\n			<p style=\"text-align:left;\"><strong>Sub: Admission for Academic Session 2015 &ndash; 2016 in Class&nbsp;$DATA.program_print_name</strong><br />\n			<br />\n			<strong>Dear&nbsp;$DATA.applicant_printname</strong><br />\n			<br />\n			Greetings from Seth M.R. Jaipuria School, Barabanki!</p>\n\n			<p style=\"text-align: justify;\">It is my pleasure to welcome you to the school. The decision of your wards schooling will be one of the most important decisions you will make in your life; where your ward would choose to study will always have an enormous impact on the direction in which their life is headed. Congratulations to you and your ward, on making that decision!</p>\n\n			<p style=\"text-align: justify;\">At Jaipuria, we understand that the many years a student spends with us would shape or break that individual, so there is great power and greater responsibility in the hands of the School. We will provide a unique opportunity for your ward to hone the skills that they truly wish to excel at. The rigorous curriculum will certainly arm them with the technical skills they need to succeed, but the experience at the School would be much more than that. The focus would be on overall development of the child, with equal impetus on co-curricular and extra-curricular activities, and unique teaching-learning styles that would truly bring out the champion in each child!</p>\n\n			<p style=\"text-align: justify;\">We are confident that your involvement as a parent/guardian will help us with our mission and give your ward the confidence they need to succeed.</p>\n\n			<p style=\"text-align: justify;\">As parents/guardians of our students you have many opportunities to get involved and stay connected, and we would be keeping you posted with the progress of your ward regularly. The school rules, regulations and holidays shall be informed to the students and parents in advance and you are welcome to discuss with us in depth.</p>\n\n			<p style=\"text-align: justify;\">We hope that our students would be able to transform themselves from what they are to what they can be in the coming years. We assure you that we would take utmost care of your wards safety, security, education and development.</p>\n\n			<p style=\"text-align: justify;\">There would be many ups and downs, joys and sorrows but one thing is for sure is that you would have un-relenting support from our side at all times. Our office bearers are always happy to listen to the advice and suggestions from parents. We are also confident that you, the parents would have utmost faith and confidence in our decision and processes, and would be as supporting toward us, as you would be toward your wards!</p>\n			</td>\n		</tr>\n	</tbody>\n</table>\n\n<div style=\"page-break-after: always\"><span style=\"display: none;\">&nbsp;</span></div>\n\n<table align=\"center\" border=\"0\" width=\"90%\">\n	<tbody>\n		<tr>\n			<td colspan=\"2\">\n			\n			<p style=\"text-align: justify;\">Our full-time teaching and non-teaching staff comprising of renowned academicians and experienced managers constitute the backbone of our school. Aesthetically built modern buildings equipped with state of the art learning aids &amp; systems, class rooms, and large green lawns &amp; open spaces make our schools an ideal place of learning.</p>\n\n			<p style=\"text-align: justify;\">In case the offer is acceptable to you, as per the terms and conditions (Annexure 1) attached, please deposit the requisite fee latest by &nbsp;$DATA.offer_exp_date along with the acknowledgement letter duly signed by you (Annexure 2). We urge regularity with payment of fees as and when it shall become due. Please note that non-payment of the fee by the last dates specified will result in automatic cancellation of the admission offer to you without any notice. Failure to pay fees timely during the course of the academic year would also lead to suspension of your ward from the school.</p>\n\n			<p style=\"text-align: justify;\">A list of annexures, required to be filled in by you and submitted to us duly supported by documents, is attached. We look forward to receiving your acceptance of this admission offer by &nbsp;$DATA.offer_exp_date, preferably earlier.</p>\n\n			<p style=\"text-align: justify;\">We encourage our students that they should always try to capture as much of the experience in the coming years as they can. The motto is that the day they walk in through the magnanimous doors of the school, marks the first day of the rest of their magnificent life, and the experience henceforth would be awesome. We are looking forward to a similar connect and bonding with the parents and guardians as well, and we hope the relationship would augur well for both of us!</p>\n\n			<p style=\"text-align: justify;\">We invite you to come experience the magnificence yourself with your wards. We look forward to meeting you and your family soon. Once again, congratulations &amp; welcome to the Jaipuria family.</p>\n\n			<p align=\"left\">For Seth M.R. Jaipuria School, Barabanki</p>\n\n			<p align=\"left\"><br />\n			(..........................)<br />\n			Principal<br />\n			Seth M.R. Jaipuria School, Barabanki</p>\n			</td>\n		</tr>\n	</tbody>\n</table>\n</body>\n</html>\n',NULL),(2,1,'UOA_OFFER_LETTER','HTMLTEMPLATE',0,NULL,NULL,NULL,NULL,'<!DOCTYPE html>\n<html>\n<head>\n	<title></title>\n	<style type=\"text/css\">body{\n    font-family:calibri;\n    font-size:15px;\n}\n	</style>\n	<style type=\"text/css\">@page { \n      margin: 5cm, 1cm, 2.5cm, 1cm; \n      @top-center { \n        content: element(pageHeader); \n      } \n\n       @bottom-center { \n        content: element(pageFooter);\n        width: 100%\n       }\n} \n\n#pageHeader{ \n   position: running(pageHeader); \n} \n#pageFooter{ \n   position: running(pageFooter); \n}\n	</style>\n</head>\n<body>\n<table border=\"0\" id=\"pageHeader\">\n	<tbody>\n		<tr>\n			<td style=\"width:50%\">\n			<p><strong><img alt=\"\" src=\"file://$DATA.img_academy_location\" style=\"height:120px; width:100px\" /></strong></p>\n			</td>\n			<td style=\"text-align:right\"><span style=\"font-size:11px\"><span style=\"font-family:arial,helvetica,sans-serif\"><span style=\"color:#0000CD\">Plot 169, Luanshya Road, Villa Elizabeth, Lusaka, Zambia<br />\n			<strong>Reg No</strong>: No: 60271 Zambia<br />\n			Zambian Ministry of Education, Science, Vocational Training &amp; Early Education <strong>Reg No</strong>: UA/LSKR/39/26<br />\n			<strong>Tel</strong>: +260 (0) 965 432 111<br />\n			<strong>E-mail</strong>: studadmin@uoaonline.net<br />\n			<strong>Web</strong>: www.universityofafrica.net</span></span></span></td>\n		</tr>\n	</tbody>\n</table>\n\n<p>&nbsp;</p>\n\n<p id=\"pageFooter\"><img height=\"70px\" src=\"http://localhost:8080/serosoft-academia-web/resources/images/uploads/offer_letter_footer1.jpg\" width=\"100%\" /></p>\n\n<p style=\"text-align:center\"><span style=\"font-size:16px\"><u><strong>$DATA.primary_dept_name</strong></u></span></p>\n\n<p>$date.get(&quot;d MMMM,y&quot;)</p>\n\n<p>$DATA.applicant_salutation $DATA.applicant_firstname $DATA.applicant_middlename $DATA.applicant_lastname<br />\n$DATA.ap_address_detail&nbsp;$DATA.ap_region_name,$DATA.ap_parent_region_name,$DATA.ap_country_name</p>\n\n<p>Dear $DATA.applicant_salutation &nbsp; $DATA.applicant_lastname</p>\n\n<p><strong>Ref: Acceptance Letter - $DATA.program_print_name</strong></p>\n\n<p>I am very pleased to inform you of your acceptance to the $DATA.organization_name as a student for the $DATA.academic_year academic year. You have been admitted to the $DATA.academy_name.</p>\n\n<p>You have been accepted for the degree of $DATA.program_print_name.&nbsp; This program aims to provide students with a good grounding in various fields as well as various options&nbsp;to specialise in a selected area. All courses within the program are designed for a rapidly changing world with innovation, market-relevance, flexibility and an international focus. The program builds a bridge between the academic environment and the global career environment.</p>\n\n<p>Your application number is&nbsp; $DATA.application_code</p>\n\n<p>Please quote this number when you are making enquiries.</p>\n\n<p>As a student, you will be encouraged to explore a wide range of academic majors available at the University.&nbsp; Through individual advice and collaboration, the academic staff of the $DATA.organization_name will work to connect you with majors that fit well with your academic strengths and future goals.</p>\n\n<p>This offer of admission is only valid for a period of three months from the date of issue. You are expected to commence your studies with the $DATA.organization_name within this grace period.&nbsp; After the grace period has expired, you will have to renew your application through a letter to the undersigned in order for the university to ensure that your acceptance is still valid.</p>\n\n<p>Fees are structured as all inclusive, and in such a way that each individual student can decide what is the most suitable for his or her own circumstances. Payment options are determined by each individual student.&nbsp; Number of modules to be studied during a specific semester is to be decided by each individual student; which may differ from semester to semester as per the choice of the student; modules taken may not exceed four per semester.</p>\n\n\n\n<p>The Admissions Office requires that you first pay the minimum tuition fee, before you receive the study materials from the University. Upon receiving proof of your payment, a receipt will be issued, which will form the basis for our logistics department to dispatch your study materials.&nbsp; Please use the receipt of the University as a proof of payment.</p>\n\n<p>We are here to help you achieve your dream through a rigorous, affordable education. Our comparative tuition fee is an important reason to choose and study with University of Africa. We strive to keep our programs economical and financially accessible to our students.&nbsp; Therefore please also ensure that we can maintain this standard through your timeous payment and adherence to the academic calendar.</p>\n\n<p>Bank payment: Students can make payments to any of our bank accounts detailed below:</p>\n\n<table border=\"1\" cellpadding=\"5\" cellspacing=\"0\">\n	<tbody>\n		<tr>\n			<td style=\"height:30px\"><strong>Bank name</strong></td>\n			<td style=\"height:30px\"><strong>Account holder</strong></td>\n			<td style=\"height:30px\"><strong>Branch</strong></td>\n			<td style=\"height:30px\"><strong>Account number</strong></td>\n		</tr>\n		<!--TC #foreach( $loopVar in $DATA.ACADEMY_LOCATION_BANKS) -->\n		<tr>\n			<td style=\"height:29px\">$loopVar.bank_name</td>\n			<td style=\"height:29px\">-</td>\n			<td style=\"height:29px\">$loopVar.branch_name</td>\n			<td style=\"height:29px\">$loopVar.bank_account_no</td>\n		</tr>\n		<!--TC #end -->\n	</tbody>\n</table>\n\n<p>&nbsp;</p>\n\n<p>Please study carefully the enclosed documents that pertain to required deposits, deadlines, and other critical information.</p>\n\n<p>Best wishes and congratulations!</p>\n\n<p>Sincerely,</p>\n\n<p>&nbsp;</p>\n\n<p>&nbsp;</p>\n\n<p>Mr. Siapemo Adams Kadakwa<br />\nBSc.ENR, Adv.Cert TMD<br />\nAdmissions and Development Manager<br />\nCell: 0977296593</p>\n\n<p>&nbsp;</p>\n\n<p>&nbsp;</p>\n</body>\n</html>\n',NULL),(3,1,'JLU_OFFER_LETTER','HTMLTEMPLATE',0,NULL,NULL,NULL,NULL,'<!DOCTYPE html>\n<html>\n<head>\n	<title></title>\n	<style type=\"text/css\">body{\n    font-family:calibri;\n    font-size:15px;\n}\np{ text-align:justify;}\n	</style>\n</head>\n<body>\n<table align=\"center\" border=\"0\" style=\"margin-top: -50px\" width=\"90%\">\n	<tbody>\n		<tr>\n			<td colspan=\"2\"> <img alt=\"\" src=\"file://$DATA.img_academy_location\" style=\"height:80px; width:300px\" /> </td>\n		</tr>\n	</tbody>\n</table>\n\n<table align=\"center\" border=\"0\" width=\"90%\">\n	<tbody>\n		<tr>\n			<td style=\"width:50%\">\n			<p><span style=\"text-align:left\">$DATA.applicant_printname<br />\n			$DATA.address_detail</span></p>\n\n			<p><span style=\"text-align:left\">$DATA.city_name<br />\n			<br />\n			Dear $DATA.applicant_firstname,</span></p>\n			</td>\n			<td style=\"text-align:right\"><span style=\"color:#0000CD\">Our Ref JLU/SOMC/ JLU-1614/<br />\n			JLU application number -$DATA.application_code<br />\n			<strong>Email</strong>: admission@jlu.edu.in<br />\n			<strong>Telephone</strong>: 0755-3917371/70<br />\n			<strong>Fax</strong>: +91(755)3040702 </span><br />\n			<br />\n			$date.get(&quot;d MMMM,y&quot;)<br />\n			Date Of Birth -$DATA.birth_date</td>\n		</tr>\n	</tbody>\n</table>\n\n<p>&nbsp;</p>\n\n<p id=\"pageFooter\">&nbsp;</p>\n\n<p style=\"text-align:center;\"><span style=\"font-size:16px\"><strong>Unconditional Admission Offer</strong></span></p>\n\n<table align=\"center\" border=\"0\" width=\"90%\">\n	<tbody>\n		<tr>\n			<td colspan=\"2\">\n			<p style=\"text-align: justify;\">Thank you for choosing to pursue your studies with Jagran Lakecity University. I am pleased to make you a unconditional offer of a place on the following program</p>\n			</td>\n		</tr>\n	</tbody>\n</table>\n\n<p style=\"text-align:center;\"><span style=\"font-size:16px\"><strong>$DATA.program_print_name </strong></span></p>\n\n<table align=\"center\" border=\"0\" width=\"90%\">\n	<tbody>\n		<tr>\n			<td>Start: $DATA.batch_start_date<br />\n			Normal duration of the program: $DATA.batch_year years</td>\n			<td align=\"right\">July 2015 Study mode: $DATA.batch_study_mode <br />\n			Your entry point: Year 1</td>\n		</tr>\n		<tr>\n			<td colspan=\"2\">\n			<p>There are no academic conditions attached with this admission offer letter.</p>\n\n			<p>Full documentary evidence of all your qualifications will be verified when you report for the orientation at the start of the program.</p>\n\n			<p>Please note the terms of all our offer of places as printed on the attached sheet.</p>\n\n			<p>Kindly deposit your first semester fee, one-time caution money and one-time alumni fee along with the enclosed reply form as soon as possible and certainly by the <u><strong> $DATA.offer_exp_date </strong></u>, otherwise it will be assumed that you have fortified the offer. After that date we cannot guarantee the availability of a place here for you. of February 2015, otherwise it will be assumed that \nyou have fortified the offer.  After that date we cannot guarantee the availability of a place here for you. </p>\n\n			<p>Please inform us about your change of address (If any) before you register or if you decide to withdraw your application at any stage. Any queries about this offer should be addressed to the Jagran Lakecity University, Bhopal Admissions Office in the first instance. Please quote your Jagran Lakecity University application number (at the top of this letter) in all future correspondence.</p>\n			</td>\n		</tr>\n	</tbody>\n</table>\n\n<table align=\"center\" border=\"0\" width=\"90%\">\n	<tbody>\n		<tr>\n			<td colspan=\"2\">\n			<p>Yours Sincerely,</p>\n\n			<p><img src=\"http://www.serosoft.in/mailer/sign.jpg\" /></p>\n			<strong>Mohit Kamble</strong><br />\n			<strong>Head - Admissions</strong><br />\n			<strong>Jagran Lakecity University, Bhopal.</strong></td>\n		</tr>\n	</tbody>\n</table>\n\n<div style=\"page-break-after: always\"><span style=\"display: none;\">&nbsp;</span></div>\n\n<table align=\"center\" border=\"0\" width=\"90%\">\n	<tbody>\n		<tr>\n			<td colspan=\"2\" style=\"border: solid thin #000000; padding:10px;\"><u><strong>PROVISIONAL FEE STRUCTURE FOR $DATA.academic_year </strong></u><br />\n			Tuition fee (per year): <strong>Rs 50,000/-</strong> (<strong>25,000/-</strong> Per Semester)<br />\n			Caution money: <strong>Rs 20,000/-</strong> (Refundable, and payable one time only at the beginning of first semester)<br />\n			Alumni Fees: <strong>Rs. 10,000/-</strong> (Non-Refundable, and payable one time only at the beginning of first semester)<br />\n			Students are also required to pay additional Bus fees / Hostel fees as mentioned below, should the student<br />\n			decide to avail these facilities:<br />\n			Bus Fees: Rs. <strong>9,000/- </strong>Per Semester.<br />\n			Hostel Fees: Triple Sharing Room: <strong>Rs. 40,000/-</strong> Per Semester | Double Sharing Room: <strong>Rs. 45,000/- </strong> Per<br />\n			Semester | Single Room: <strong>Rs. 50,000/- </strong>Per Semester<br />\n			Hostel Security Deposit: <strong>Rs.5000/- </strong>(Refundable, and payable one time only at the beginning of first semester)</td>\n		</tr>\n	</tbody>\n</table>\n\n<table align=\"center\" border=\"0\" width=\"90%\">\n	<tbody>\n		<tr>\n			<td colspan=\"2\"><strong>TERMS OF THIS OFFER&nbsp;$DATA.academic_year</strong><br />\n			<u><strong>GENERAL</strong></u>\n\n			<p style=\"text-align: justify;\">These terms and conditions represent only part of the University&#39;s regulations. You should ensure that you read the University&#39;s general and other student rules &amp; regulations book, as amended from time to time, which can be accessed by the following the notifications made on the University website: www.jlu.edu.in</p>\n\n			<p>This provisional admission offer letter is made on the assumption that you have provided the University with all relevant information required to be considered fully and fairly. Should it subsequently come to light that you have withheld or misrepresented any material information, that you have made any false statements during the application and selection process, or that you are unable to provide full documentary evidence of your qualifications when you start the program, the University reserves the right to revoke your admission or registration and enrolment as a student.</p>\n\n			<p><u><strong>DISCLAIMER</strong></u></p>\n\n			<p>Should you become a student at Jagran Lakecity University; the University will take all reasonable steps to provide the programs as described in the current Prospectus. However, please note that the Prospectus is provided for information purposes only and is not a definitive statement of the programs or facilities to be provided by the University.</p>\n\n			<p>In some circumstances the University may be unable to deliver the programs or facilities described. Reasons why the University may need to cancel or vary a program might include, without limitation, changes to the level of, or conditions attached to, the minimum number of student enrolments required for commencement of an academic program; changes to its teaching staff, changes to the accommodation and facilities available to the University; or incidents which are of more general application but which have a direct effect on the University, for example, an epidemic, natural disaster or other event beyond the control of the University.</p>\n\n			<p>If, after an application for a program has been accepted, the program is substantially varied from that described in the Prospectus or cancelled for reasons other than circumstances beyond the University&#39;s control, the University will endeavour to provide a suitable replacement program. If the student does not wish to accept the replacement program the student is entitled to withdraw from the program. In the event of such a withdrawal an appropriate refund of program fees will be made. Please refer to the University&#39;s General Regulations for further guidance on the rules that will apply in circumstances such as these.</p>\n			</td>\n		</tr>\n	</tbody>\n</table>\n\n<div style=\"page-break-after: always\"><span style=\"display: none;\">&nbsp;</span></div>\n\n<table align=\"center\" border=\"0\" width=\"90%\">\n	<tbody>\n		<tr>\n			<td colspan=\"2\"><br />\n			<u><strong>PAYMENT OF FEES</strong></u>\n\n			<p>As a prospective student you should be aware that you yourself are responsible for meeting your fees and any additional financial requirements related to your studies. You should begin to make the necessary financial arrangements now if you have not already done so.</p>\n\n			<p>If a student does not pay full composite fees in accordance with University regulations and such fees remain outstanding beyond the terms allowed for payment, the University reserves the right to suspend the student&#39;s registration and to prevent registration for any other programme of study. For these purposes suspension shall entail the withdrawal of all educational services from the University. In cases where any such debts remain unresolved the student will not receive her/his academic award until such time as the debts have been fully discharged by or on behalf of the student.</p>\n			</td>\n		</tr>\n	</tbody>\n</table>\n\n<div style=\"page-break-after: always\"><span style=\"display: none;\">&nbsp;</span></div>\n\n<p style=\"text-align:center; text-decoration:none; padding:3px; margin:3px;\"><span style=\"font-size:14px\"><u><strong>Reply to Unconditional Offer Letter</strong></u></span></p>\n\n<p style=\"text-align:center; text-decoration:none; padding:3px; margin:3px;\"><span style=\"font-size:14px\">To: JAGRAN LAKECITY UNIVERSITY, BHOPAL<br />\n165, First Floor, Zone 1,<br />\nBehind Axis Bank,MP Nagar<br />\nBhopal (MP) - 462011</span></p>\n\n<table align=\"center\" border=\"0\" width=\"100%\">\n	<tbody>\n		<tr>\n			<td colspan=\"2\">\n			<hr /></td>\n		</tr>\n		<tr>\n			<td colspan=\"2\">\n			<table align=\"left\" cellpadding=\"8\">\n				<tbody>\n					<tr>\n						<td valign=\"top\"><strong>From:</strong><br />\n						<strong>Program:</strong><br />\n						<strong>Offer reference:</strong><br />\n						<strong>Date of offer:</strong></td>\n						<td width=\"12%\">&nbsp;</td>\n						<td valign=\"top\">$DATA.applicant_printname<br />\n						$DATA.program_print_name<br />\n						JLU/SOMC/ JLU-1614/<br />\n						<span style=\"text-align: right;\">$date.get(&quot;d MMMM,y&quot;)</span></td>\n						<td width=\"10%\">&nbsp;</td>\n						<td valign=\"top\"><strong>Application number: </strong> &nbsp;$DATA.application_code</td>\n					</tr>\n				</tbody>\n			</table>\n			</td>\n		</tr>\n		<tr>\n			<td colspan=\"2\">\n			<hr /></td>\n		</tr>\n	</tbody>\n</table>\n\n<table align=\"center\" border=\"0\" width=\"100%\">\n	<tbody>\n		<tr>\n			<td colspan=\"2\">\n			<p align=\"center\" style=\"padding: 3px; margin: 3px;\">PLEASE TICK THE RELEVANT BOXES AND STRIKE OFF THE IRRELEVANT SENTENCES BELOW</p>\n\n			<p style=\"margin-left: 0px;\"><input type=\"checkbox\" />&nbsp;&nbsp;[ ] &nbsp; I accept the University&#39;s provisional admission offer of a place</p>\n\n			<p style=\"padding-left: 50px; padding: 3px; margin: 3px;\"><input type=\"checkbox\" />&nbsp;&nbsp; [ ] &nbsp; I intend to finance my studies out of personal or family resources. I undertake to pay the program fees in accordance with the University&#39;s Financial Regulations (a copy of which is available upon request).</p>\n\n			<p>OR</p>\n\n			<p style=\"padding-left: 50px; padding: 3px; margin: 3px;\"> &#x25a2; &nbsp;&nbsp; [ ] &nbsp; I intend to secure sponsorship</p>\n\n			<p style=\"padding-left: 80px; padding: 3px; margin: 3px;\"><input type=\"checkbox\" />&nbsp;&nbsp; [ ] &nbsp; I enclose a completed Sponsorship Form / sponsor&#39;s letter.</p>\n\n			<p style=\"padding-left: 80px; padding: 3px; margin: 3px;\"><input type=\"checkbox\" />&nbsp;&nbsp; [ ] &nbsp; I am unable to send immediately a completed Sponsorship Form or sponsor&#39;s letter.</p>\n\n			<p style=\"padding-left: 80px; padding: 3px; margin: 3px;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; [ ] &nbsp; I expect to be able to send one of these by (date): ............................................................</p>\n\n			<p style=\"padding: 3px; margin: 3px;\"><input type=\"checkbox\" />&nbsp;&nbsp; [ ] &nbsp; I am aware that I am required to meet maintenance/living expenses myself, in addition to the program fees and additional financial requirements.</p>\n\n			<p style=\"padding:3px; margin:3px;\">OR</p>\n\n			<p><input type=\"checkbox\" />&nbsp;&nbsp; [ ] &nbsp; I am unable to accept the offer and withdraw my application for these reasons:</p>\n\n			<p>.......................................................................................................................................................<br />\n			<input type=\"checkbox\" />&nbsp;&nbsp; [ ] &nbsp; I confirm that all the information I have so far submitted to the University in support of my application remains complete and accurate. There have been no significant recent changes in my circumstances.</p>\n\n			<p style=\"padding:3px; margin:3px;\">OR</p>\n\n			<p style=\"padding:3px; margin:3px;\"><input type=\"checkbox\" />&nbsp;&nbsp; [ ] &nbsp; Please note the attached/following change in my circumstances/correction to previously submitted information: .........................................................................................................................<br />\n			......................................................................................................................... (Please enclose any relevant documentary evidence.)</p>\n\n			<p style=\"padding:3px; margin:3px;\">Signed: ........................................................................... &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Date: ................................</p>\n			</td>\n		</tr>\n		<tr>\n			<td colspan=\"2\">\n			<hr /></td>\n		</tr>\n		<tr>\n			<td colspan=\"2\">\n			<p align=\"center\" style=\"text-align:center;padding:3px; margin:3px;\">This form should be completed and returned to the University Admission office at the earliest and<br />\n			certainly before the $DATA.offer_exp_date . Please send any further information as soon as it becomes available.</p>\n			</td>\n		</tr>\n		<tr>\n			<td colspan=\"2\">\n			<hr /></td>\n		</tr>\n	</tbody>\n</table>\n</body>\n</html>\n','');

-- issue fixed by mukesh for student address 
UPDATE  `dydt_templateparams_translations` SET `translationCode`='ap_country_name' WHERE `id`='39';
UPDATE  `dydt_templateparams_translations` SET `translationCode`='ap_region_name' WHERE `id`='40';
UPDATE  `dydt_templateparams_translations` SET `translationCode`='ap_parent_region_name' WHERE `id`='41';
UPDATE  `dydt_templateparams_translations` SET `translationCode`='ap_city_name' WHERE `id`='42';
UPDATE  `dydt_templateparams_translations` SET `translationCode`='ap_address_detail' WHERE `id`='43';
UPDATE  `dydt_templateparams_translations` SET `translationCode`='ap_phone_country_code' WHERE `id`='44';
UPDATE  `dydt_templateparams_translations` SET `translationCode`='ap_phone_area_code' WHERE `id`='45';
UPDATE  `dydt_templateparams_translations` SET `translationCode`='ap_phone_no' WHERE `id`='46';
UPDATE  `dydt_templateparams_translations` SET `translationCode`='ap_cell_country_code' WHERE `id`='47';
UPDATE  `dydt_templateparams_translations` SET `translationCode`='ap_cell_no' WHERE `id`='48';
UPDATE  `dydt_templateparams_translations` SET `translationCode`='ap_primary_email_id' WHERE `id`='49';

UPDATE `dydt_data_line_item` SET `sqlSelectQueryDef`='SELECT  c.countryName AS ap_country_name , cr.countryRegionName AS ap_region_name ,\npr.countryRegionName AS ap_parent_region_name,ct.cityName AS ap_city_name , addressText AS ap_address_detail,\nad.phoneCountryCode AS ap_phone_country_code,ad.phoneAreaCode AS ap_phone_area_code,\nad.phoneNo AS ap_phone_no ,ad.cellCountryCode AS ap_cell_country_code,ad.cellNo AS ap_cell_no ,\nad.primaryEmailId AS ap_primary_email_id\nFROM applicant_address ad\nLEFT JOIN city ct ON ct.id =ad.cityId\nLEFT JOIN country c ON ad.countryId = c.id\nLEFT JOIN country_region cr ON ad.countryRegionId = cr.id\nLEFT JOIN country_region pr ON ad.parentRegionId = pr.id' WHERE `id`='9' and`whetherPrimaryDataSource`='0';


UPDATE `dydt_data_line_item` SET `resultColumnsDef`='ap_country_name,ap_region_name,ap_parent_region_name,ap_city_name,ap_address_detail,ap_phone_country_code,ap_phone_area_code,ap_phone_no,
ap_cell_country_code,ap_cell_no,ap_primary_email_id' WHERE `id`='9' and`whetherPrimaryDataSource`='0';

-- added code by utsav, remove where clause from bank details query
UPDATE `dydt_data_line_item` SET `whereClauseBindingDef`=NULL, 
`sqlWhereQueryDef`=NULL WHERE `id`='12' and dataSourceCode='ACADEMY_LOCATION_BANKS';


-- Added certificate print data provider



SET @admissionProviderId=(SELECT MAX(id) FROM dydt_data_provider);



INSERT INTO `dydt_data_provider` (`id`, `providerName`, `priority`) VALUES(@admissionProviderId+1,'ADMISSION_DATA_PROVIDER','1');


SET @dataLineItemId1=(SELECT MAX(id) FROM dydt_data_line_item);

INSERT INTO `dydt_data_line_item` (`id`, `dataProviderId`, `dataSourceCode`, `executionOrder`, `publishAsParametersDef`, `whetherDataSource`, `whetherPrimaryDataSource`, `sqlSelectQueryDef`, `whereClauseBindingDef`, `resultColumnsDef`, `formattersDef`, `sqlWhereQueryDef`, `whetherMultiRecord`) 
VALUES(@dataLineItemId1+1,@admissionProviderId+1,'ADMISSION_INFO','1','student_id=PRM_STUDENT_ID','1','1','SELECT  p.programCode AS program_code,p.programName AS program_name,p.programNameToBePrint AS program_print_name,\r\npd.shortCode AS primary_dept_code,pd.deptName AS primary_dept_name,\r\npsd.shortCode AS secondary_dept_code,psd.deptName AS secondary_dept_name,\r\nb.batchName AS batch_name ,b.startDate AS batch_start_date ,b.tillDate AS batch_tilldate,\r\nay.yearName AS academic_year ,a.code AS admission_code ,a.studentId as student_id\r\nFROM admission a\r\nINNER JOIN programs p ON a.programId = p.id\r\nINNER JOIN prog_batch_seat_config pbsc ON a.programBatchSeatConfigId = pbsc.id\r\nINNER JOIN batches b   ON b.id = pbsc.programBatchId\r\nINNER JOIN academy_year ay ON ay.id = b.academicYear\r\nINNER JOIN department pd ON pd.id = p.programDepartmentId\r\nLEFT JOIN department psd ON psd.id = p.subDepartmentId','PRM_ADMISSION_ID','program_code,program_name,program_print_name, primary_dept_code,primary_dept_name,secondary_dept_code,secondary_dept_name, batch_name, batch_start_date,batch_end_date,batch_tilldate,academic_year,admission_code,student_id',NULL,'WHERE a.id = PRM_ADMISSION_ID','0');

SET @dataLineItemId2=(SELECT MAX(id) FROM dydt_data_line_item);

INSERT INTO `dydt_data_line_item` (`id`, `dataProviderId`, `dataSourceCode`, `executionOrder`, `publishAsParametersDef`, `whetherDataSource`, `whetherPrimaryDataSource`, `sqlSelectQueryDef`, `whereClauseBindingDef`, `resultColumnsDef`, `formattersDef`, `sqlWhereQueryDef`, `whetherMultiRecord`) 
VALUES(@dataLineItemId2+1,@admissionProviderId+1,'ADMISSION_INFO','1',NULL,'1','1','SELECT p.firstName AS student_firstname ,p.lastName AS student_lastname ,p.middleName AS student_middlename, \r\np.gender AS student_gender,p.printName  AS student_printname,\r\nsln.salutationName AS applicant_salutation,p.birthDate AS birth_date\r\nFROM students s\r\nINNER JOIN  persons p ON s.personId = p.id\r\nINNER JOIN salutations sln ON p.salutationId = sln.id\r\n','PRM_STUDENT_ID','student_firstname,student_lastname,student_middlename,student_gender,student_printname,applicant_salutation,birth_date',NULL,'WHERE s.userId=PRM_STUDENT_ID\r\n','0');


SET @courseDataProviderId=(SELECT MAX(id) FROM dydt_data_provider);

INSERT INTO `dydt_data_provider` (`id`, `providerName`, `priority`) VALUES(@courseDataProviderId+1,'COURSE_DATA_PROVIDER','1');

SET @dataLineItemId3=(SELECT MAX(id) FROM dydt_data_line_item);

INSERT INTO `dydt_data_line_item` (`id`, `dataProviderId`, `dataSourceCode`, `executionOrder`, `publishAsParametersDef`, `whetherDataSource`, `whetherPrimaryDataSource`, `sqlSelectQueryDef`, `whereClauseBindingDef`, `resultColumnsDef`, `formattersDef`, `sqlWhereQueryDef`, `whetherMultiRecord`)
VALUES(@dataLineItemId3+1,@courseDataProviderId+1,'COURSE_INFO','1',NULL,'1','0','SELECT courseCode AS course_code,courseName AS course_name,courseShortName AS course_short_name,nameToBePrinted AS print_name,courseMarksGrades AS mark_grades,courseGradeType AS grade_type,courseShortDescription AS course_description,\r\ncourseStage AS course_stage FROM courses c','PRM_COURSE_ID','course_code,course_name,course_short_name,print_name,mark_grades,grade_type,course_description,course_stage',NULL,'WHERE c.id=PRM_COURSE_ID','0');


SET @communtityDataProviderId=(SELECT MAX(id) FROM dydt_data_provider);

INSERT INTO `dydt_data_provider` (`id`, `providerName`, `priority`) VALUES(@communtityDataProviderId+1,'COMMUNITY_DATA_PROVIDER','1');

SET @dataLineItemId4=(SELECT MAX(id) FROM dydt_data_line_item);

INSERT INTO `dydt_data_line_item` (`id`, `dataProviderId`, `dataSourceCode`, `executionOrder`, `publishAsParametersDef`, `whetherDataSource`, `whetherPrimaryDataSource`, `sqlSelectQueryDef`, `whereClauseBindingDef`, `resultColumnsDef`, `formattersDef`, `sqlWhereQueryDef`, `whetherMultiRecord`) 
VALUES(@dataLineItemId4+1,@communtityDataProviderId+1,'COMMUNITY_INFO','1',NULL,'1','0','SELECT communityCode AS community_code,communityName AS community_name FROM `community` com','PRM_COMMUNITY_ID','community_code,community_name',NULL,'WHERE com.id=PRM_COMMUNITY_ID','0');


SET @communtityDataProviderId=(SELECT MAX(id) FROM dydt_data_provider);


INSERT INTO `dydt_data_provider` (`id`, `providerName`, `priority`) VALUES(@communtityDataProviderId+1,'USER_INFO_PROVIDER','1');

SET @dataLineItemId5=(SELECT MAX(id) FROM dydt_data_line_item);

INSERT INTO `dydt_data_line_item` (`id`, `dataProviderId`, `dataSourceCode`, `executionOrder`, `publishAsParametersDef`, `whetherDataSource`, `whetherPrimaryDataSource`, `sqlSelectQueryDef`, `whereClauseBindingDef`, `resultColumnsDef`, `formattersDef`, `sqlWhereQueryDef`, `whetherMultiRecord`) 
VALUES(@dataLineItemId5+1,@communtityDataProviderId+1,'USER_INFO','1',NULL,'1','1','SELECT T2.id AS ID,T5.`salutationName` AS salutation_name,T2.`firstName` AS first_name,\r\n        T2.`middleName` AS middle_name,T2.`lastName` AS last_name,\r\n        T3.`emailId` AS email_id,T3.`mobileNumber` AS mobile_number ,\r\nCASE WHEN T4.personId IS NULL THEN T1.personId ELSE T4.personID END \r\nFROM persons T3\r\nLEFT JOIN students T4 ON T3.id = T4.personId\r\nLEFT JOIN staffs T1 ON T3.id =T1.personId\r\nLEFT JOIN `salutations` T5 ON T5.`id`=T3.`salutationId` \r\nLEFT JOIN users T2 ON ( T4.userId = T2.id OR T1.userId = T2.id )','PRM_USER_ID','salutation_name,first_name,middle_name,last_name,email_id,mobile_number',NULL,'WHERE \r\n  ( T4.userId = PRM_USER_ID OR T1.userId = PRM_USER_ID );\r\n','0');


SET @academyLocationDataProviderId=(SELECT MAX(id) FROM dydt_data_provider);


INSERT INTO `dydt_data_provider` (`id`, `providerName`, `priority`) VALUES(@academyLocationDataProviderId+1,'ACADEMY_LOCATION_INFO_PROVIDER','1');


SET @dataLineItemId6=(SELECT MAX(id) FROM dydt_data_line_item);

INSERT INTO `dydt_data_line_item` (`id`, `dataProviderId`, `dataSourceCode`, `executionOrder`, `publishAsParametersDef`, `whetherDataSource`, `whetherPrimaryDataSource`, `sqlSelectQueryDef`, `whereClauseBindingDef`, `resultColumnsDef`, `formattersDef`, `sqlWhereQueryDef`, `whetherMultiRecord`)
VALUES(@dataLineItemId6+1,@academyLocationDataProviderId+1,'ACADEMY_LOCATION_INFO','1',NULL,'1','1','SELECT academy.academyName AS academy_name,academy.academicTypeCode AS academic_type_code,academy.shortCode AS academy_short_code,location.locationName AS location_name,location.shortCode AS location_short_code \r\nFROM academy_location al\r\nINNER JOIN academies academy ON academy.id=al.academyId\r\nINNER JOIN locations location ON location.id=al.locationId','PRM_ACADEMY_LOCATION_ID','academy_name,academic_type_code,academy_short_code,location_name,location_short_code',NULL,' WHERE al.id=PRM_ACADEMY_LOCATION_ID','0');



SET @certificateInfoProviderId=(SELECT MAX(id) FROM dydt_data_provider);

INSERT INTO `dydt_data_provider` (`id`, `providerName`, `priority`) VALUES(@certificateInfoProviderId+1,'CERTIFICATE_INFO_PROVIDER','1');

SET @dataLineItemId7=(SELECT MAX(id) FROM dydt_data_line_item);




INSERT INTO `dydt_data_line_item` (`id`, `dataProviderId`, `dataSourceCode`, `executionOrder`, `publishAsParametersDef`, `whetherDataSource`, `whetherPrimaryDataSource`, `sqlSelectQueryDef`, `whereClauseBindingDef`, `resultColumnsDef`, `formattersDef`, `sqlWhereQueryDef`, `whetherMultiRecord`) 
VALUES(@dataLineItemId7+1,@certificateInfoProviderId+1,'CERTIFICATE_INFO','1',NULL,'1','1','SELECT c.certificateCode AS certificate_code,c.certificateName AS certificate_name FROM certificates c','PRM_CERTIFICATE_ID','certificate_code,certificate_name',NULL,'WHERE c.id=PRM_CERTIFICATE_ID','0');



SET @dydt_document_param1=(SELECT MAX(id) FROM dydt_document_param);

INSERT INTO `dydt_document_param` (`id`, `paramCode`) VALUES(@dydt_document_param1+1,'PRM_ADMISSION_ID');

SET @dydt_document_param2=(SELECT MAX(id) FROM dydt_document_param);

INSERT INTO `dydt_document_param` (`id`, `paramCode`) VALUES(@dydt_document_param2+1,'PRM_COURSE_ID');

SET @dydt_document_param3=(SELECT MAX(id) FROM dydt_document_param);

INSERT INTO `dydt_document_param` (`id`, `paramCode`) VALUES(@dydt_document_param3+1,'PRM_COMMUNITY_ID');

SET @dydt_document_param4=(SELECT MAX(id) FROM dydt_document_param);

INSERT INTO `dydt_document_param` (`id`, `paramCode`) VALUES(@dydt_document_param4+1,'PRM_ACADEMY_LOCATION_ID');

SET @dydt_document_param5=(SELECT MAX(id) FROM dydt_document_param);

INSERT INTO `dydt_document_param` (`id`, `paramCode`) VALUES(@dydt_document_param5+1,'PRM_USER_ID');

SET @dydt_document_param6=(SELECT MAX(id) FROM dydt_document_param);

INSERT INTO `dydt_document_param` (`id`, `paramCode`) VALUES(@dydt_document_param6+1,'PRM_CERTIFICATE_ID');


-- --------------------------------------



SET FOREIGN_KEY_CHECKS= 1;


-- Added DPS PAO


INSERT INTO `dydt_template_conf`
(`documentTypeId`, `templateName`  , `templateType`, `whetherDefault`, `previewImage`, `repeatHeader`, `repeatFooter`, `reportParams`, `templateContent`, `mainReportPath`) 
VALUES 
(1,'DPS_NURSERY_PAO','HTMLTEMPLATE',0,NULL,NULL,NULL,NULL,'<!DOCTYPE html>\n<html>\n<head>\n	<title></title>\n	<style type=\"text/css\">body{\n	    	font-family:calibri;\n	    	font-size:15px;\n		}\n@page { \n		\n      margin: 5cm, 1cm, 3cm, 1cm;\n      @top-center { \n        	content: element(pageHeader); \n      } \n\n       @bottom-center { \n        	content: element(pageFooter);\n        	width: 100%\n       }\n	}\n	</style>\n	<style type=\"text/css\">.amount{\n			text-align: right;\n		}\n\n        #pageHeader{ \n  			position: running(pageHeader); \n		} \n		#pageFooter{ \n   			position: running(pageFooter); \n		}\n	</style>\n</head>\n<body>\n<p>&nbsp;</p>\n\n<table align=\"center\" border=\"0\" id=\"pageHeader\" style=\"margin-top: 150px\" width=\"90%\">\n</table>\n\n<table align=\"center\" border=\"0\" width=\"90%\">\n	<tbody>\n		<tr>\n			<td align=\"center\" colspan=\"2\"><img src=\"http://localhost:8080/serosoft-academia-web/resources/images/uploads/dps_kolar.jpg\" style=\"height: 150px; width: 670px; display:none\" /></td>\n		</tr>\n		<tr>\n			<td align=\"center\" colspan=\"2\" style=\"font-weight:bold;\">PROVISIONAL ADMISSION ORDER</td>\n		</tr>\n		<tr>\n			<td align=\"center\" colspan=\"2\">SESSION: $DATA.academic_year</td>\n		</tr>\n	</tbody>\n</table>\n\n<p>&nbsp;</p>\n\n<table align=\"center\" border=\"0\" width=\"90%\">\n	<tbody>\n		<tr>\n			<td><span style=\"text-align:left\"><strong>Regn No : $DATA.application_code</strong> </span><br />\n			<br />\n			<br />\n			&nbsp;</td>\n		</tr>\n		<tr>\n			<td align=\"right\"><span style=\"text-align:right;\"><strong>Date : $date.get(&quot;d MMMM, y&quot;)</strong> </span></td>\n		</tr>\n		<tr>\n			<td><strong>Name of the child : $DATA.applicant_firstname $DATA.applicant_lastname</strong><br />\n			<br />\n			<strong>Dear Parents, </strong></td>\n		</tr>\n		<tr>\n			<td colspan=\"2\">\n			<p style=\"text-align: justify;\">We are pleased to inform you that your ward has been selected for admission for the session <strong>$DATA.academic_year</strong> in class:&nbsp;<strong>$DATA.program_name</strong></p>\n\n			<p style=\"text-align: justify;\">You are advised to contact Admin. Office, DPS Campus, Kolar Road, Bhopal to complete the admission formalities within 5 days from the date of declaration of result, between 9:00 am to 1:00 pm excluding Sundays &amp; Holidays.</p>\n\n			<p style=\"text-align: justify;\">Kindly submit the following documents:-</p>\n\n			<ol style=\"padding:0px 0px 0px 20px;\">\n				<li style=\"text-align: justify;\">Enrolment Form (in enclosed Proforma)</li>\n				<li style=\"text-align: justify;\">Health Card (in enclosed Proforma) to be certified by the registered practicing family doctor.</li>\n				<li style=\"text-align: justify;\">Original birth certificate (for certifying the photocopy of birth certificate) issued by Nagar Nigam / Municipal Corporation.</li>\n				<li style=\"text-align: justify;\">Two colour passport size photographs of the child.</li>\n				<li style=\"text-align: justify;\">Parents Identity Proof.</li>\n				<li style=\"text-align: justify;\">SSSMID of family &amp; Students is mandatory for the admission. If not available, it can be obtained from Municipal ward of our area.</li>\n			</ol>\n\n			<p style=\"text-align: justify;\">Deposit a sum of Rs. 61,500/- (Rupees Sixty One Thousand Five Hundred only) strictly in CASH or by way of DEMAND DRAFT in favour of JSWS Account - DPS, Kolar Road, Bhopal payable at Bhopal, as detailed below:- (Cheques not accepted)</p>\n\n			<table border=\"0\" cellpadding=\"2\" cellspacing=\"2\" style=\"width:95%;\">\n				<tbody>\n					<tr>\n						<td>(a) Admission fee (Non Refundable)</td>\n						<td class=\"amount\">Rs. 40,000.00</td>\n					</tr>\n					<tr>\n						<td>(b) Alumni fund (Non Refundable)</td>\n						<td class=\"amount\">Rs. 07,500.00</td>\n					</tr>\n					<tr>\n						<td>(c) Transport Fund (Non Refundable)</td>\n						<td class=\"amount\">Rs. 09,000.00</td>\n					</tr>\n					<tr>\n						<td>(d) Caution Money (Refundable)</td>\n						<td class=\"amount\">Rs. 05,000.00</td>\n					</tr>\n					<tr>\n						<td align=\"right\"><strong>Total: </strong></td>\n						<td class=\"amount\"><strong>Rs. 61,500.00</strong></td>\n					</tr>\n				</tbody>\n			</table>\n\n			<table align=\"center\" border=\"0\" style=\"margin-top: 80px\" width=\"90%\">\n			</table>\n\n			<table align=\"center\" border=\"0\" id=\"pageFooter\" style=\"margin-top: 50\" width=\"90%\">\n			</table>\n\n			<p style=\"text-align: justify;\"><strong>Please note that the following documents must be submitted prior to joining the school: </strong></p>\n\n			<ol style=\"padding:0px 0px 0px 20px;\">\n				<li style=\"text-align: justify;\">Original Mark Sheet of present class issued by school where the ward is presently studying.</li>\n				<li style=\"text-align: justify;\">Transfer Certificate in original. In case of transfer from CBSE affiliated school, the TC must be countersinged by the Regional CBSE office. Admission will be cancelled on failing to submit the same.</li>\n				<li style=\"text-align: justify;\">Incase of transfer from MP Board, countersigned TC by D.E.O. of the district is to be submitted.</li>\n				<li style=\"text-align: justify;\">Proof of parents transfer to Bhopal district from another district or state on account of transfer in Govt. / Private organization.</li>\n				<li style=\"text-align: justify;\">In case of admission in Class X, photocopy of Class IX registration no. with CBSE.</li>\n			</ol>\n			</td>\n		</tr>\n		<tr>\n			<td colspan=\"2\">\n			<p style=\"text-align: justify;\"><strong>Please note that in case admission is not taken within the specified time, the vacancy will be offered to the wait listed candidates. No claim for admission will be entertained subsequently. </strong></p>\n\n			<p align=\"right\" style=\"margin-top:60px\"><br />\n			<strong>PRINCIPAL / AUTHORISED SIGNATORY</strong></p>\n			</td>\n		</tr>\n	</tbody>\n</table>\n</body>\n</html>\n',NULL);

INSERT INTO `dydt_template_conf` 
(`documentTypeId`, `templateName`  , `templateType`, `whetherDefault`, `previewImage`, `repeatHeader`, `repeatFooter`, `reportParams`, `templateContent`, `mainReportPath`) 
VALUES 
(1,'DPS_123_PAO','HTMLTEMPLATE',0,NULL,NULL,NULL,NULL,'<!DOCTYPE html>\n<html>\n<head>\n	<title></title>\n	<style type=\"text/css\">body{\n	    	font-family:calibri;\n	    	font-size:15px;\n		}\n@page { \n		\n      margin: 5cm, 1cm, 3cm, 1cm;\n      @top-center { \n        	content: element(pageHeader); \n      } \n\n       @bottom-center { \n        	content: element(pageFooter);\n        	width: 100%\n       }\n	}\n	</style>\n	<style type=\"text/css\">.amount{\n			text-align: right;\n		}\n\n        #pageHeader{ \n  			position: running(pageHeader); \n		} \n		#pageFooter{ \n   			position: running(pageFooter); \n		}\n	</style>\n</head>\n<body>\n<p>&nbsp;</p>\n\n<table align=\"center\" border=\"0\" id=\"pageHeader\" style=\"margin-top: 150px\" width=\"90%\">\n</table>\n\n<table align=\"center\" border=\"0\" width=\"90%\">\n	<tbody>\n		<tr>\n			<td align=\"center\" colspan=\"2\"><img src=\"http://localhost:8080/serosoft-academia-web/resources/images/uploads/dps_kolar.jpg\" style=\"height: 150px; width: 670px; display:none\" /></td>\n		</tr>\n		<tr>\n			<td align=\"center\" colspan=\"2\" style=\"font-weight:bold;\">PROVISIONAL ADMISSION ORDER</td>\n		</tr>\n		<tr>\n			<td align=\"center\" colspan=\"2\">SESSION: $DATA.academic_year</td>\n		</tr>\n	</tbody>\n</table>\n\n<p>&nbsp;</p>\n\n<table align=\"center\" border=\"0\" width=\"90%\">\n	<tbody>\n		<tr>\n			<td><span style=\"text-align:left\"><strong>Regn No : $DATA.application_code</strong> </span><br />\n			<br />\n			<br />\n			&nbsp;</td>\n		</tr>\n		<tr>\n			<td align=\"right\"><span style=\"text-align:right;\"><strong>Date : $date.get(&quot;d MMMM, y&quot;)</strong> </span></td>\n		</tr>\n		<tr>\n			<td><strong>Name of the child : $DATA.applicant_firstname $DATA.applicant_lastname</strong><br />\n			<br />\n			<strong>Dear Parents, </strong></td>\n		</tr>\n		<tr>\n			<td colspan=\"2\">\n			<p style=\"text-align: justify;\">We are pleased to inform you that your ward has been selected for admission for the session <strong>$DATA.academic_year</strong> in class: &nbsp;<strong>$DATA.program_name </strong></p>\n\n			<p style=\"text-align: justify;\">You are advised to contact Admin. Office, DPS Campus, Kolar Road, Bhopal to complete the admission formalities within 5 days from the date of declaration of result, between 9:00 am to 1:00 pm excluding Sundays &amp; Holidays</p>\n\n			<p style=\"text-align: justify;\">Kindly submit the following documents : -</p>\n\n			<ol style=\"padding:0px 0px 0px 20px;\">\n				<li>Enrolment Form (in enclosed Proforma)</li>\n				<li>Health Card (in enclosed Proforma) to be certified by the registered practicing family doctor.</li>\n				<li>Photocopy of Birth Certificate and Original Birth Certificate (for verification) issued by Nagar Nigam / Municipal Corporation.</li>\n				<li>Three colour passport size photographs of the child.</li>\n				<li>Parents Identity Proof.</li>\n			</ol>\n\n			<p style=\"text-align: justify;\">Deposit a sum of Rs. 61,500/- (Rupees Sixty One Thousand Five Hundred only) strictly in CASH or by way of DEMAND DRAFT in favour of JSWS Account - DPS, Kolar Road, Bhopal payable at Bhopal, as detailed below:- (Cheques not accepted)</p>\n\n			<table border=\"0\" cellpadding=\"2\" cellspacing=\"2\" style=\"width:95%;\">\n				<tbody>\n					<tr>\n						<td>(a) Admission fee (Non Refundable)</td>\n						<td class=\"amount\">Rs. 40,000.00</td>\n					</tr>\n					<tr>\n						<td>(b) Alumni fund (Non Refundable)</td>\n						<td class=\"amount\">Rs. 07,500.00</td>\n					</tr>\n					<tr>\n						<td>(c) Transport Fund (Non Refundable)</td>\n						<td class=\"amount\">Rs. 09,000.00</td>\n					</tr>\n					<tr>\n						<td>(d) Caution Money (Refundable)</td>\n						<td class=\"amount\">Rs. 05,000.00</td>\n					</tr>\n					<tr>\n						<td align=\"right\"><strong>Total: </strong></td>\n						<td class=\"amount\"><strong>Rs. 61,500.00</strong></td>\n					</tr>\n				</tbody>\n			</table>\n\n			<table align=\"center\" border=\"0\" style=\"margin-top: 110px\" width=\"90%\">\n			</table>\n\n			<table align=\"center\" border=\"0\" id=\"pageFooter\" style=\"margin-top: 50\" width=\"90%\">\n			</table>\n\n			<p style=\"text-align: justify;\"><strong>Please note that the following documents must be submitted prior to joining the school:</strong></p>\n\n			<ol style=\"padding:0px 0px 0px 20px;\">\n				<li>Original Mark Sheet of present class issued by school where the ward is presently studying.</li>\n				<li>Transfer Certificate in original. In case of transfer from CBSE affiliated school, the TC must be countersinged by the Regional CBSE office. Admission will be cancelled on failing to submit the same.</li>\n				<li>In case of transfer from MP Board, countersigned TC by D.E.O. of the district is to be submitted.</li>\n				<li>Proof of parents transfer to Bhopal district from another district or state on account of transfer in Govt. / Private organization.</li>\n			</ol>\n			</td>\n		</tr>\n		<tr>\n			<td colspan=\"2\">\n			<p style=\"text-align: justify;\"><strong>Please note that in case admission is not taken within the specified time, the vacancy will be offered to the wait listed candidates. No claim for admission will be entertained subsequently.</strong></p>\n\n			<p align=\"right\" style=\"margin-top:60px\"><br />\n			<strong>PRINCIPAL / AUTHORISED SIGNATORY</strong></p>\n			</td>\n		</tr>\n	</tbody>\n</table>\n</body>\n</html>\n',NULL);

INSERT INTO `dydt_template_conf`(`documentTypeId`, `templateName`  , `templateType`, `whetherDefault`, `previewImage`, `repeatHeader`, `repeatFooter`, `reportParams`, `templateContent`, `mainReportPath`) 
VALUES 
(1,'DPS_428_PAO','HTMLTEMPLATE',0,NULL,NULL,NULL,NULL,'<!DOCTYPE html>\n<html>\n<head>\n	<title></title>\n	<style type=\"text/css\">body{\n	    	font-family:calibri;\n	    	font-size:15px;\n		}\n@page { \n		\n      margin: 5cm, 1cm, 3cm, 1cm;\n      @top-center { \n        	content: element(pageHeader); \n      } \n\n       @bottom-center { \n        	content: element(pageFooter);\n        	width: 100%;\n       }\n	}\n	</style>\n	<style type=\"text/css\">.amount{\n			text-align: right;\n		}\n		\n		ul > li{\n			display:inline-block;\n		}\n\n		li >div{\n			display:inline-block;\n			margin-top: 10px;\n			margin-right: 50px;\n			margin-left: 25px;\n			border:1px solid black;\n			width: 15px;\n			height:15px;\n			margin-bottom: -5px;\n		}\n		\n        #pageHeader{ \n  			position: running(pageHeader); \n		} \n		#pageFooter{ \n   			position: running(pageFooter); \n		}\n	</style>\n</head>\n<body>\n<p>&nbsp;</p>\n\n<table align=\"center\" border=\"0\" id=\"pageHeader\" style=\"margin-top: 150px\" width=\"90%\">\n</table>\n\n<table align=\"center\" border=\"0\" width=\"90%\">\n	<tbody>\n		<tr>\n			<td align=\"center\"><img src=\"http://localhost:8080/serosoft-academia-web/resources/images/uploads/dps_kolar.jpg\" style=\"height: 150px; width: 670px; display:none\" /></td>\n		</tr>\n		<tr>\n			<td align=\"center\" style=\"font-weight:bold;\">PROVISIONAL ADMISSION ORDER</td>\n		</tr>\n		<tr>\n			<td align=\"center\">SESSION: $DATA.academic_year</td>\n		</tr>\n	</tbody>\n</table>\n\n<p>&nbsp;</p>\n\n<table align=\"center\" border=\"0\" width=\"90%\">\n	<tbody>\n		<tr>\n			<td><span style=\"text-align:left\"><strong>Regn No : $DATA.application_code</strong> </span><br />\n			<br />\n			<br />\n			&nbsp;</td>\n		</tr>\n		<tr>\n			<td align=\"right\"><span style=\"text-align:right;\"><strong>Date : $date.get(&quot;d MMMM, y&quot;)</strong> </span></td>\n		</tr>\n		<tr>\n			<td><strong>Name of the child : $DATA.applicant_firstname $DATA.applicant_lastname</strong><br />\n			<br />\n			<strong>Dear Parents, </strong></td>\n		</tr>\n		<tr>\n			<td>\n			<p style=\"text-align: justify;\">We are pleased to inform you that your ward has been selected for admission for the session <strong>$DATA.academic_year</strong> in class:&nbsp;<strong>$DATA.program_name</strong></p>\n\n			<p style=\"text-align: justify;\">You are advised to contact Admin. Office, DPS Campus, Kolar Road, Bhopal to complete the admission formalities within 5 days from the date of declaration of result, between 9:00 am to 1:00 pm excluding Sundays &amp; Holidays.</p>\n\n			<p style=\"text-align: justify;\">Kindly submit the following documents:-</p>\n\n			<ol style=\"padding:0px 0px 0px 20px;\">\n				<li style=\"text-align: justify;\">Enrolment Form (in enclosed Proforma)</li>\n				<li style=\"text-align: justify;\">Health Card (in enclosed Proforma) to be certified by the registered practicing family doctor.</li>\n				<li style=\"text-align: justify;\">Photocopy of Birth Certificate and Original Birth Certificate (for verification) issued by Nagar Nigam / Municipal Corporation.</li>\n				<li style=\"text-align: justify;\">Three colour passport size photographs of the child.</li>\n				<li style=\"text-align: justify;\">Parents Identity Proof.</li>\n				<li style=\"text-align: justify;\">SSSMID of family &amp; Students is mandatory for the admission. If not available, it can be obtained from Municipal ward of our area.</li>\n				<li style=\"text-align: justify;\">Third Language Option (Pl. tick) :-\n				<ul style=\"\">\n					<li>French\n					<div>&nbsp;</div>\n					</li>\n					<li>Sanskrit\n					<div>&nbsp;</div>\n					</li>\n					<li>Urdu\n					<div>&nbsp;</div>\n					</li>\n				</ul>\n				</li>\n			</ol>\n\n			<p style=\"text-align: justify;\">Deposit a sum of Rs. 61,500/- (Rupees Sixty One Thousand Five Hundred only) strictly in CASH or by way of DEMAND DRAFT in favour of JSWS Account - DPS, Kolar Road, Bhopal payable at Bhopal, as detailed below:- (Cheques not accepted)</p>\n\n			<table border=\"0\" cellpadding=\"2\" cellspacing=\"2\" style=\"width:95%;\">\n				<tbody>\n					<tr>\n						<td>(a) Admission fee (Non Refundable)</td>\n						<td class=\"amount\">Rs. 40,000.00</td>\n					</tr>\n					<tr>\n						<td>(b) Alumni fund (Non Refundable)</td>\n						<td class=\"amount\">Rs. 07,500.00</td>\n					</tr>\n					<tr>\n						<td>(c) Transport Fund (Non Refundable)</td>\n						<td class=\"amount\">Rs. 09,000.00</td>\n					</tr>\n					<tr>\n						<td>(d) Caution Money (Refundable)</td>\n						<td class=\"amount\">Rs. 05,000.00</td>\n					</tr>\n					<tr>\n						<td align=\"right\"><strong>Total: </strong></td>\n						<td class=\"amount\"><strong>Rs. 61,500.00</strong></td>\n					</tr>\n				</tbody>\n			</table>\n\n			<table align=\"center\" border=\"0\" style=\"margin-top: 80px\" width=\"90%\">\n			</table>\n\n			<table align=\"center\" border=\"0\" id=\"pageFooter\" style=\"margin-top: 50\" width=\"90%\">\n			</table>\n\n			<p style=\"text-align: justify;\"><strong>Please note that the following documents must be submitted prior to joining the school: </strong></p>\n\n			<ol style=\"padding:0px 0px 0px 20px;\">\n				<li style=\"text-align: justify;\">Original Mark Sheet of present class issued by school where the ward is presently studying.</li>\n				<li style=\"text-align: justify;\">Transfer Certificate in original. In case of transfer from CBSE affiliated school, the TC must be countersinged by the Regional CBSE office. Admission will be cancelled on failing to submit the same.</li>\n				<li style=\"text-align: justify;\">In case of transfer from MP Board, countersigned TC by D.E.O. of the district is to be submitted.</li>\n				<li style=\"text-align: justify;\">Proof of parents transfer to Bhopal district from another district or state on account of transfer in Govt. / Private organization.</li>\n				<li style=\"text-align: justify;\">In case of admission in Class X, photocopy of Class IX registration no. with CBSE.</li>\n			</ol>\n			</td>\n		</tr>\n		<tr>\n			<td>\n			<p style=\"text-align: justify;\"><strong>Please note that in case admission is not taken within the specified time, the vacancy will be offered to the wait listed candidates. No claim for admission will be entertained subsequently. </strong></p>\n\n			<p align=\"right\" style=\"margin-top:60px\"><br />\n			<strong>PRINCIPAL / AUTHORISED SIGNATORY</strong></p>\n			</td>\n		</tr>\n	</tbody>\n</table>\n</body>\n</html>\n',NULL);

INSERT INTO `dydt_template_conf` (`documentTypeId`, `templateName`  , `templateType`, `whetherDefault`, `previewImage`, `repeatHeader`, `repeatFooter`, `reportParams`, `templateContent`, `mainReportPath`) 
VALUES 
(1,'DPS_9210_PAO','HTMLTEMPLATE',0,NULL,NULL,NULL,NULL,'<!DOCTYPE html>\n<html>\n<head>\n	<title></title>\n	<style type=\"text/css\">body{\n	    	font-family:calibri;\n	    	font-size:15px;\n		}\n@page { \n		\n      margin: 5cm, 1cm, 3cm, 1cm;\n      @top-center { \n        	content: element(pageHeader); \n      } \n\n       @bottom-center { \n        	content: element(pageFooter);\n        	width: 100%;\n       }\n	}\n	</style>\n	<style type=\"text/css\">.amount{\n			text-align: right;\n		}\n		\n		ul > li{\n			display:inline-block;\n		}\n\n		li >div{\n			display:inline-block;\n			margin-top: 10px;\n			margin-right: 50px;\n			margin-left: 25px;\n			border:1px solid black;\n			width: 15px;\n			height:15px;\n			margin-bottom: -5px;\n		}\n		\n        #pageHeader{ \n  			position: running(pageHeader); \n		} \n		#pageFooter{ \n   			position: running(pageFooter); \n		}\n	</style>\n</head>\n<body>\n<p>&nbsp;</p>\n\n<table align=\"center\" border=\"0\" id=\"pageHeader\" style=\"margin-top: 150px\" width=\"90%\">\n</table>\n\n<table align=\"center\" border=\"0\" width=\"90%\">\n	<tbody>\n		<tr>\n			<td align=\"center\"><img src=\"http://localhost:8080/serosoft-academia-web/resources/images/uploads/dps_kolar.jpg\" style=\"height: 150px; width: 670px; display:none\" /></td>\n		</tr>\n		<tr>\n			<td align=\"center\" style=\"font-weight:bold;\">PROVISIONAL ADMISSION ORDER</td>\n		</tr>\n		<tr>\n			<td align=\"center\">SESSION: $DATA.academic_year</td>\n		</tr>\n	</tbody>\n</table>\n\n<p>&nbsp;</p>\n\n<table align=\"center\" border=\"0\" width=\"90%\">\n	<tbody>\n		<tr>\n			<td><span style=\"text-align:left\"><strong>Regn No : $DATA.application_code</strong> </span><br />\n			<br />\n			<br />\n			&nbsp;</td>\n		</tr>\n		<tr>\n			<td align=\"right\"><span style=\"text-align:right;\"><strong>Date : $date.get(&quot;d MMMM, y&quot;)</strong> </span></td>\n		</tr>\n		<tr>\n			<td><strong>Name of the child : $DATA.applicant_firstname $DATA.applicant_lastname</strong><br />\n			<br />\n			<strong>Dear Parents, </strong></td>\n		</tr>\n		<tr>\n			<td>\n			<p style=\"text-align: justify;\">We are pleased to inform you that your ward has been selected for admission for the session <strong>$DATA.academic_year</strong> in class:&nbsp;<strong>$DATA.program_name</strong></p>\n\n			<p style=\"text-align: justify;\">You are advised to contact Administrative Office to complete the admission formalities within 5 days from the date of issue of PAO, between 9:00 am to 1:00 pm excluding Sundays &amp; Holidays.</p>\n\n			<p style=\"text-align: justify;\">Kindly submit the following documents:-</p>\n\n			<ol style=\"padding:0px 0px 0px 20px;\">\n				<li style=\"text-align: justify;\">Enrolment Form (in enclosed Proforma)</li>\n				<li style=\"text-align: justify;\">Health Card (in enclosed Proforma) to be certified by the registered practicing family doctor.</li>\n				<li style=\"text-align: justify;\">Photocopy of Birth Certificate and Original Birth Certificate (for verification) issued by Nagar Nigam / Municipal Corporation.</li>\n				<li style=\"text-align: justify;\">Three colour passport size photographs of the child.</li>\n				<li style=\"text-align: justify;\">Parents Identity Proof.</li>\n				<li style=\"text-align: justify;\">SSSMID of family &amp; Students is mandatory for the admission. If not available, it can be obtained from Municipal ward of our area.</li>\n				<li style=\"text-align: justify;\">Second Language Option (Pl. Tick) :-\n				<ul style=\"\">\n					<li>French\n					<div>&nbsp;</div>\n					</li>\n					<li>Sanskrit\n					<div>&nbsp;</div>\n					</li>\n					<li>Hindi\n					<div>&nbsp;</div>\n					</li>\n				</ul>\n				</li>\n			</ol>\n\n			<p style=\"text-align: justify;\">Deposit a sum of Rs. 61,500/- (Rupees Sixty One Thousand Five Hundred only) strictly in CASH or by way of DEMAND DRAFT in favour of JSWS Account - DPS, Kolar Road, Bhopal payable at Bhopal, as detailed below:- (Cheques not accepted)</p>\n\n			<table border=\"0\" cellpadding=\"2\" cellspacing=\"2\" style=\"width:95%;\">\n				<tbody>\n					<tr>\n						<td>(a) Admission fee (Non Refundable)</td>\n						<td class=\"amount\">Rs. 40,000.00</td>\n					</tr>\n					<tr>\n						<td>(b) Alumni fund (Non Refundable)</td>\n						<td class=\"amount\">Rs. 07,500.00</td>\n					</tr>\n					<tr>\n						<td>(c) Transport Fund (Non Refundable)</td>\n						<td class=\"amount\">Rs. 09,000.00</td>\n					</tr>\n					<tr>\n						<td>(d) Caution Money (Refundable)</td>\n						<td class=\"amount\">Rs. 05,000.00</td>\n					</tr>\n					<tr>\n						<td align=\"right\"><strong>Total: </strong></td>\n						<td class=\"amount\"><strong>Rs. 61,500.00</strong></td>\n					</tr>\n				</tbody>\n			</table>\n\n			<table align=\"center\" border=\"0\" style=\"margin-top: 80px\" width=\"90%\">\n			</table>\n\n			<table align=\"center\" border=\"0\" id=\"pageFooter\" style=\"margin-top: 50\" width=\"90%\">\n			</table>\n\n			<p style=\"text-align: justify;\"><strong>Please note that the following documents must be submitted prior to joining the school: </strong></p>\n\n			<ol style=\"padding:0px 0px 0px 20px;\">\n				<li style=\"text-align: justify;\">Original Mark Sheet of present class issued by school where the ward is presently studying.</li>\n				<li style=\"text-align: justify;\">Transfer Certificate in original. In case of transfer from CBSE affiliated school, the TC must be countersinged by the Regional CBSE office. Admission will be cancelled on failing to submit the same.</li>\n				<li style=\"text-align: justify;\">Incase of transfer from MP Board, countersigned TC by D.E.O. of the district is to be submitted.</li>\n				<li style=\"text-align: justify;\">Proof of parents transfer to Bhopal district from another district or state on account of transfer in Govt. / Private organization.</li>\n				<li style=\"text-align: justify;\">In case of admission in Class X, photocopy of Class IX registration no. with CBSE.</li>\n			</ol>\n			</td>\n		</tr>\n		<tr>\n			<td>\n			<p style=\"text-align: justify;\"><strong>Please note that in case admission is not taken within the specified time, the vacancy will be offered to the wait listed candidates. No claim for admission will be entertained subsequently. </strong></p>\n\n			<p align=\"right\" style=\"margin-top:60px\"><br />\n			<strong>PRINCIPAL / AUTHORISED SIGNATORY</strong></p>\n			</td>\n		</tr>\n	</tbody>\n</table>\n</body>\n</html>\n',NULL);
